package org.msh.tb.cases;

import org.jboss.seam.international.Messages;
import org.msh.tb.entities.TbCase;
import org.msh.tb.entities.enums.Gender;

public class CaseItemData {
    private Integer id;
    private String name;
    private Integer recordNumber;
    private Integer caseNumber;
    private Gender gender;
    private String displayCaseNumber;

    public CaseItemData() {}

    public CaseItemData(Integer id, String name, Integer recordNumber, Integer caseNumber, Gender gender) {
        this.id = id;
        this.name = name;
        this.recordNumber = recordNumber;
        this.caseNumber = caseNumber;
        this.gender = gender;
        if (recordNumber != null && caseNumber != null) {
            this.displayCaseNumber = TbCase.formatCaseNumber(recordNumber, caseNumber);
        } else {
            this.displayCaseNumber = Messages.instance().get("cases.nonumber");
        }
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getRecordNumber() {
        return recordNumber;
    }

    public void setRecordNumber(Integer recordNumber) {
        this.recordNumber = recordNumber;
    }

    public Integer getCaseNumber() {
        return caseNumber;
    }

    public void setCaseNumber(Integer caseNumber) {
        this.caseNumber = caseNumber;
    }

    public Gender getGender() {
        return gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getDisplayCaseNumber() {
        return displayCaseNumber;
    }

    public void setDisplayCaseNumber(String displayCaseNumber) {
        this.displayCaseNumber = displayCaseNumber;
    }
}
